/*
 * ACPHY PAPD CAL module interface (to other PHY modules).
 *
 * Copyright (C) 2015, Broadcom Corporation
 * All Rights Reserved.
 * 
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Broadcom Corporation;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Broadcom Corporation.
 *
 * $Id$
 */

#ifndef _phy_ac_papdcal_h_
#define _phy_ac_papdcal_h_

#include <phy_api.h>
#include <phy_ac.h>
#include <phy_papdcal.h>

/* forward declaration */
typedef struct phy_ac_papdcal_info phy_ac_papdcal_info_t;

/* register/unregister ACPHY specific implementations to/from common */
phy_ac_papdcal_info_t *phy_ac_papdcal_register_impl(phy_info_t *pi,
	phy_ac_info_t *aci, phy_papdcal_info_t *mi);
void phy_ac_papdcal_unregister_impl(phy_ac_papdcal_info_t *info);


/* ************************************************************************* */
/* ************************************************************************* */
/* ************************************************************************* */
/* ************************************************************************* */
extern uint16 papd_gainctrl_pga[];

/* used for PAPD cal */
typedef struct _acphy_txgains {
	uint16 txlpf;
	uint16 txgm;
	uint16 pga;
	uint16 pad;
	uint16 ipa;
} acphy_txgains_t;

#define ACPHY_PAPD_EPS_TBL_SIZE		64
extern void wlc_phy_papd_phy_cleanup_acphy(phy_info_t *pi);
extern void wlc_phy_papd_cal_acphy(phy_info_t *pi, uint16 num_iter, uint8 core, uint16 startindex,
	uint16 yrefindex, uint16 stopindex);
extern void wlc_phy_papd_set_rfpwrlut(phy_info_t *pi);
extern void wlc_phy_txpwr_papd_cal_run_acphy(phy_info_t *pi, uint8 tx_pre_cal_pwr_ctrl_state);
#ifdef IMPLICIT_TXBF
#define IMPTXBF 1
#define IMP_PRE_CAL_STATE 0
extern void papd_pi_flip_calc_txbf(phy_info_t *pi, int16 *papd_phase,
	uint16 num_iter, uint8 core, uint16 startindex, uint16 yrefindex, uint16 end);
extern int16 cordic_atan2(int X, int Y);
extern int16 find_quad(int* X, int* Y);
extern void wlc_phy_tiny_papd_cal_run_acphy(phy_info_t *pi,
	uint8 tx_pre_cal_pwr_ctrl_state, bool txbf_enab);
extern void implicit_txbf_cal(phy_info_t *pi);
#else
#define IMPTXBF 0
extern void wlc_phy_tiny_papd_cal_run_acphy(phy_info_t *pi,
	uint8 tx_pre_cal_pwr_ctrl_state);
#endif /* IMPLICIT_TXBF	*/
#if defined(BCMDBG)
extern void wlc_phy_papd_dump_eps_trace_acphy(phy_info_t *pi, struct bcmstrbuf *b);
#endif 
extern void wlc_phy_papd_phy_setup_acphy(phy_info_t *pi);

/* Analytic PAPD Support */
#ifndef DONGLEBUILD
	#ifndef WL_APAPD
		#define WL_APAPD
		#define APAPD_ENAB(aci)                                          (aci->_apapd)
	#endif /* WL_APAPD */
#else
	#ifdef WL_APAPD
		#define APAPD_ENAB(aci)                                          (aci->_apapd)
	#else
		#define APAPD_ENAB(aci)                                          (0)
	#endif /* WL_APAPD */
#endif /* !DONGLEBUILD */

#endif /* _phy_ac_papdcal_h_ */
